##################################################################################################
## Modélisation Python d'un asservissement discretisé (second ordre quelconque !!)
###########################################################################
import numpy as np
import matplotlib.pyplot as plt

K=100 #correcteur
Te=0.1 #echantillonage

t=[i for i in np.arange(0,60.1,0.1)] #échelle de temps
e=[0 for i in np.arange(0,1,0.1)]+[16 for i in np.arange(1,60.1,0.1)] #consigne échelon

s=[e[0],e[1]] #intialisation

for i in range(1,len(e)-1):
    s.append(Te**2/250*(e[i]*0.8*K + 1.6*K/Te*(e[i]-e[i-1]) - (1+0.8*K)*s[i] - 127/Te* (s[i]-s[i-1]) ) + 2*s[i] - s[i-1] )
    #équation du second ordre s[i+1] calculé à patir de s[i] et s[i-1]

plt.plot(t,e,label='consigne')
plt.plot(t,s,label='sortie')
plt.legend()
plt.show()