# -*- coding: utf-8 -*-
"""
Created on Sun May  9 23:09:36 2021

@author: Fabien
"""

#from copy import deepcopy

import pandas as pd
import numpy as np
import matplotlib.pyplot as plt

plt.ion()


dataset = pd.read_csv(r"\\serveur01\HOSPITF\Travail\Téléchargements\CORRECTIONS/datas/Temp_annuelle_France.csv")
Xt = dataset[["Annee"]].to_numpy(dtype=float)
yt = dataset[["Temp"]].to_numpy(dtype=float)

# TRACE Dataset
plt.figure(1)
plt.plot(Xt,yt,'b.')
plt.xlabel('Annee'); plt.ylabel('Temp. [°C]')

mu_Xt = np.mean(Xt) ; sigma_Xt = np.std(Xt)
Xt = (Xt - mu_Xt)/sigma_Xt

mu_yt = np.mean(yt) ; sigma_yt = np.std(yt)
yt = (yt - mu_yt)/sigma_yt


def h(X,W):
    return X.dot(W)

def J(X,Y,W):
    N=np.shape(X)[0]
    cout = sum((h(X,W)-Y)**2)
    return (1/(2*N))*cout

def Gradient(X,Y,W):
    N = np.shape(X)[0]
    return 1/N * X.T.dot(h(X,W)-Y)

def Degre_multiple(X,d):
    N = X.shape[0]
    U = np.ones((N,1))
    if d==0:
        R=U
    else:
        R=np.hstack((U,X))
        k=2
        while k<=d:
            R=np.hstack((R,X**k))
            k+=1
    return R

def Regression_Lineaire(X,Y,degre,nbre_iter=1000,alpha=0.01):
    W = np.random.randn(degre+1,1)
    X = Degre_multiple(X,degre)
    Histoire_cout = [J(X,Y,W)]
    k=0
    while k<nbre_iter :
        W = W - alpha*Gradient(X,Y,W)
        Histoire_cout.append(J(X,Y,W))
        k+=1
    return W,Histoire_cout

L_W = []; L_cout = []
for k in range(0,7):
    W,ch = Regression_Lineaire(Xt,yt,k,nbre_iter=5000,alpha=0.02)
    L_W.append(W); L_cout.append(ch)

plt.figure(2)
for k in range(len(L_cout)):
    plt.plot(L_cout[k],label="degré = {}".format(k))
plt.xlabel("Nombre itérations")
plt.ylabel("Cout")
plt.legend()

def Prediction(X,W):
    degre = len(W)-1
    X = Degre_multiple(X,degre)
    return h(X,W)

plt.figure(1)
for k in range(len(L_W)):
    ym = Prediction(Xt,L_W[k])
    X = Xt*sigma_Xt + mu_Xt
    ym = ym*sigma_yt + mu_yt
    plt.plot(X,ym,label="degré = {}".format(k))

# Un degré 4 semble être la solution offrant le modèle le plus proche pour prédire.
# prédiction températures en 2030, 2050 et 2100...

Xp = np.array([[2030,2040,2050]]).T
Xpn = (Xp - mu_Xt)/sigma_Xt #On normalise pour coller au modèle
yp = Prediction(Xpn,L_W[3]) # On prend le modèle de degré 4
yp = yp*sigma_yt + mu_yt

plt.figure(1)
plt.plot(Xp,yp,'ko')