# -*- coding: utf-8 -*-
"""
Created on Fri Jun 18 14:04:43 2021

@author: Fabien
"""

from sklearn.linear_model import LinearRegression
from sklearn.preprocessing import PolynomialFeatures
from sklearn.metrics import mean_squared_error, r2_score
import pandas as pd
import matplotlib.pyplot as plt
import numpy as np

# Etape 1 : Recuperation du dataset
donnees = pd.read_csv(r"\\serveur01\HOSPITF\Travail\Téléchargements\CORRECTIONS/datas/Temp_annuelle_France.csv")
Xt = donnees["Annee"].to_numpy()
yt = donnees["Temp"].to_numpy(dtype=float)
X = Xt.reshape((len(Xt)),1)
Y = yt.reshape((len(yt)),1)
plt.figure()
plt.scatter(X,Y)

# Etape 2 : Preparation des donnees
degre = 4
transformation_polynomiale = PolynomialFeatures(degree = degre)
X_t = transformation_polynomiale.fit_transform(X)

# Etape 3: Definition et entraînement du modèle
Modele_RP = LinearRegression()
Modele_RP.fit(X_t, Y)

# Etape 4 : prediction
x_new_min = 1900
x_new_max = 2050
Xp = np.linspace(x_new_min, x_new_max, 2050-1900)
Xp = Xp[:,np.newaxis]
Xp_t = transformation_polynomiale.fit_transform(Xp)
Yp = Modele_RP.predict(Xp_t)

# Etape 5 : Graphiques
plt.plot(Xp, Yp, color='coral', linewidth=3)
plt.grid()
plt.xlim(x_new_min,x_new_max)
title = 'Degree = {}'.format(degre)
plt.title("Regression Lineaire multiple (polynomiale) \n " + title,
          fontsize=10)
plt.xlabel('x')
plt.ylabel('y')
#plt.savefig("polynomial_linear_regression.png", bbox_inches='tight')
plt.show()

# Calculs des erreurs
Ym = Modele_RP.predict(X_t)
rmse = np.sqrt(mean_squared_error(Y,Ym))
r2 = r2_score(Y,Ym)
print('RMSE: ', rmse)
print('R2: ', r2)



