/*Analyse des propriétés*/

/*Q1*/
SELECT * FROM propriete ORDER BY nom ASC;

/*Q2*/
SELECT * FROM propriete WHERE nom LIKE 'gare%' OR nom LIKE 'compagnie%';

/*Q3*/
SELECT * FROM propriete EXCEPT SELECT * FROM propriete WHERE nom LIKE 'gare%' OR nom LIKE 'compagnie%'; 
/*ou*/
SELECT * FROM propriete WHERE nom NOT LIKE 'gare%' AND nom NOT LIKE 'compagnie%';

/*Q4*/
SELECT COUNT(*) FROM propriete WHERE nom LIKE 'gare%';
/*REPONSE : 4*/

/*Q5*/
SELECT COUNT(*), serie FROM couleur GROUP BY serie;
/* REPONSE : 3 séries de 2 cartes, 6 séries de 3 cartes, 1 série de 4 cartes.*/

/*Q6*/
SELECT propriete.id, couleur.nom AS couleur, propriete.nom , loyer, loyer*2 AS loyer_double, loyer_hotel, couleur.prix_hotel, prix 
FROM propriete 
    JOIN couleur ON propriete.couleur_id=couleur.id ;
/*ou*/
SELECT propriete.id, couleur.nom AS couleur, propriete.nom , loyer, loyer*2 AS loyer_double, loyer_hotel, couleur.prix_hotel, prix 
FROM propriete, couleur 
    WHERE propriete.couleur_id=couleur.id ;
    
/*Q7*/
SELECT propriete.id, couleur.nom, propriete.nom, loyer, loyer*2, loyer_hotel, couleur.prix_hotel, prix 
FROM propriete 
    JOIN couleur ON propriete.couleur_id=couleur.id 
    WHERE propriete.nom LIKE '%belleville';
/*ou*/
SELECT * FROM carte_propriete_vw WHERE nom LIKE '%belleville';

/*Q8 Synthèse*/
/*Relation 1 à plusiquers entre couleur/propriete : 
    Clef primaire : couleur.id
    Clef étrangère : propriete.couleur_id
Relation 1 à plusieurs entre joueur/propriete :
    Clef primaire : joueur.id
    Clef étrangère : propriete.joueur_id

/*Pouvoir d'achat du groupe*/

/*Q9*/
SELECT SUM(porte_monnaie) FROM joueur;
/*REPONSE : 1910*/

/*Q10*/
SELECT SUM(prix) FROM propriete WHERE joueur_id IS NULL;
/*REPONSE : 1650*/

/*Q11*/
/*SUM(porte_monnaie)>SUM(prix) donc oui*/

/*Q12*/
SELECT SUM(prix_hotel) FROM couleur 
    JOIN propriete ON couleur.id=propriete.couleur_id 
    WHERE propriete.presence_hotel=false;
/*REPONSE : 9100*/

/*Q13*/
/*SUM(porte_monnaie)<SUM(prix_hotel) donc non.*/

/*Cartes chances*/

/*Q14*/
SELECT joueur.surnom AS joueur, chance.nom AS chance FROM joueur_chance
    JOIN joueur ON joueur.id=joueur_chance.joueur_id
    JOIN chance ON chance.id=joueur_chance.chance_id;

/*Q15 Synthèse */
/*Relation plusieurs à plusieurs entre chance/joueur.
La table joueur_chance permet de décomposer la relation plusieurs à plusieurs en deux relations 1 à plusieurs.*/

/*C'est parti - Tour i+1 - Chapeau*/

/*Q16*/
/*On peut faire 2 à 12 avec le dé, ce qui correspond aux cases entre Place de la Bourse et Avenue des Champs-Elysées inclues.*/

/*Q17*/
SELECT id,nom FROM propriete WHERE nom LIKE "%bourse" AND nom LIKE "%elysees";

/*Q18*/ /*ATTENTION seules les cases propriétés possèdent des id. Les autres cases n'existent pas dans la base de données, il faut donc adapter la LIMIT et l'OFFSET à cela (on va de 20 à 27 et pas de 20 à 32)*/
SELECT * FROM carte_propriete_vw
    LIMIT (
        (SELECT id AS id_chmps_elysees FROM propriete WHERE nom LIKE '%elysees')
        -
        (SELECT id AS id_gdn FROM propriete WHERE nom = 'place_de_la_bourse')
        +1
        )
    OFFSET (
        (SELECT id AS id_gdn FROM propriete WHERE nom = 'place_de_la_bourse')
        -1
        );

/*Q19*/
SELECT AVG(prix) FROM propriete WHERE (id>=20 AND id<=27);
/*REPONSE : 270 000€*/

/*Q20*/
SELECT nom,MAX(loyer) FROM propriete 
    WHERE (id>=20 AND id<=27) AND joueur_id IS NOT NULL AND joueur_id<>1;
/*REPONSE : Boulevard des Capucines, 160 000€ */

/*Q21*/
SELECT nom,MAX(loyer_hotel) FROM propriete 
    WHERE (id>18 AND id<=27) AND presence_hotel=true AND joueur_id<>1;
/*Avenue Foch : 600 000€*/

/*Q22*/
SELECT nom, loyer, loyer*2 AS loyer_double, loyer_hotel FROM propriete 
    WHERE nom LIKE '%foch';

/*Q23*/
SELECT joueur_id FROM propriete WHERE id=24;
/*ou*/
SELECT joueur_id FROM propriete WHERE nom LIKE '%foch';

/*Q24*/
SELECT joueur.id, joueur.surnom, propriete.nom FROM joueur
    JOIN propriete ON propriete.joueur_id=joueur.id 
    WHERE propriete.nom LIKE '%foch';

/*Q25*/
SELECT propriete.nom, joueur_id, presence_hotel FROM propriete 
    WHERE joueur_id=
        (SELECT joueur_id FROM propriete WHERE id=24) 
    AND couleur_id=
        (SELECT couleur_id FROM propriete WHERE id=24);

/*Q26*/
/* Loyer (Foch avec hôtel ) : 600 000€
Porte_monnaie du joueur : 550 000€ donc non. */

/*Q27*/
SELECT nom, MIN(prix) FROM propriete 
    WHERE joueur_id=1 AND presence_hotel=false 
    AND prix>=50;
/*REPONSE : Rue de Courcelles : 100 000€ */

/*Tour i+2 - Voiture*/

/*Q28*/
SELECT joueur.surnom, porte_monnaie, propriete.nom, couleur.nom,presence_hotel FROM propriete 
    JOIN joueur ON joueur.id=propriete.joueur_id 
    JOIN couleur ON couleur.id=propriete.couleur_id 
    WHERE surnom LIKE 'voiture';

/*Q29*/
SELECT nom, prix FROM propriete 
    WHERE prix<=
        (SELECT porte_monnaie FROM joueur WHERE surnom LIKE 'voiture');

/*Q30*/
SELECT nom, prix FROM propriete 
    WHERE prix<=
        (SELECT porte_monnaie FROM joueur WHERE surnom LIKE 'voiture') 
    AND (joueur_id IS NULL) 
    ORDER BY prix DESC;
    
/*Q31*/
SELECT porte_monnaie + SUM(prix) + SUM(prix_hotel*presence_hotel) FROM joueur 
    JOIN propriete ON joueur.id=propriete.joueur_id
    JOIN couleur ON couleur.id=propriete.couleur_id
    WHERE surnom LIKE 'voiture'; 
/*ou*/
SELECT porte_monnaie + SUM(prix) + 
    (SELECT SUM(prix_hotel) FROM couleur 
        JOIN propriete ON couleur.id=propriete.couleur_id 
        JOIN joueur ON joueur.id=propriete.joueur_id 
        WHERE surnom LIKE 'voiture' 
        AND presence_hotel=true)
FROM joueur 
    JOIN propriete ON joueur.id=propriete.joueur_id
    WHERE surnom LIKE 'voiture';
/*Reponse : 2 620 000 € */

/*Q32*/
SELECT 
    joueur.surnom, 
    loyer*
        (SELECT COUNT(nom) FROM propriete WHERE nom LIKE 'gare%'
        AND joueur_id=(
            SELECT joueur_id FROM propriete WHERE nom LIKE '%lyon')
        ) 
        AS loyer_3_gares
FROM propriete 
    JOIN joueur ON propriete.joueur_id=joueur.id 
    WHERE propriete.nom LIKE '%lyon';
/*REPONSE : 150 000€*/

/*Tour i+3 - Toutou*/
    
/*Q33*/
SELECT COUNT(propriete.nom) AS nbre_proprietes, couleur.nom AS couleur FROM propriete 
    JOIN couleur ON propriete.couleur_id=couleur.id 
    WHERE joueur_id=3 
    GROUP BY couleur;
    
/*Q34*/
SELECT COUNT(propriete.nom) AS nbre_de_propriete, couleur.nom AS couleur, couleur.serie FROM propriete 
    JOIN couleur ON propriete.couleur_id=couleur.id 
    WHERE joueur_id=3 
    GROUP BY couleur 
    HAVING nbre_de_propriete=couleur.serie-1;
    
/*Q35*/
SELECT * FROM propriete 
    WHERE (couleur.nom='rouge' OR couleur.nom='compagnie') 
    AND joueur_id IS NULL;
    
/*Q36*/
 SELECT * FROM propriete 
     JOIN couleur ON couleur.id=propriete.couleur_id 
     WHERE couleur.nom LIKE 'rouge' OR couleur.nom LIKE 'rose' 
     ORDER BY prix_hotel ASC;
     
/*Q37*/
SELECT MIN(prix_hotel) FROM propriete 
    JOIN couleur ON couleur.id=propriete.couleur_id 
    WHERE couleur.nom LIKE 'rouge' OR couleur.nom LIKE 'rose';
/*REPONSE : prix min d'hôtel est de 350 000, budget de 810 000, donc max 2 hôtels.*/

/*Q38*/
SELECT 
    proprieteA.nom AS nomA, 
    proprieteB.nom AS nomB, 
    proprieteA.prix_hotel+proprieteB.prix_hotel AS somme_prix_hotel 
FROM carte_propriete_vw AS proprieteA 
    JOIN carte_propriete_vw AS proprieteB 
    ON proprieteA.nom <> proprieteB.nom AND proprieteA.nom<proprieteB.nom /*Permet d'évites les doublons*/
    WHERE (proprieteA.couleur LIKE 'rouge' OR proprieteA.couleur LIKE 'rose') 
    AND (proprieteB.couleur LIKE 'rouge' OR proprieteB.couleur LIKE 'rose')
    AND somme_prix_hotel<=810;