--
-- Fichier généré par SQLiteStudio v3.3.3 sur mer. sept. 1 16:22:00 2021
--
-- Encodage texte utilisé : System
--
PRAGMA foreign_keys = off;
BEGIN TRANSACTION;

-- Table : chance
DROP TABLE IF EXISTS chance;
CREATE TABLE chance (
    id          INTEGER       NOT NULL
                              PRIMARY KEY AUTOINCREMENT,
    nom         VARCHAR (100) NOT NULL,
    description VARCHAR       NOT NULL
);
INSERT INTO chance (id, nom, description) VALUES (1, 'Sortez de prison', 'Vous pouvez sortir de prison. Placez votre pion sur visite simple, et jouez normalement.');
INSERT INTO chance (id, nom, description) VALUES (2, 'Ne payez pas le loyer', 'A ce tour, vous n''êtes pas obligé de payer le loyer, quel qu''il soit.');
INSERT INTO chance (id, nom, description) VALUES (3, 'Avancez jusqu''à la case départ', 'A jouer à votre tour, avant de lancer les dés. Avancez directement jusqu''à la case départ et recevez 200 m€. Vous pouvez ensuite jouer normalement.');

-- Table : couleur
DROP TABLE IF EXISTS couleur;
CREATE TABLE couleur (
'id' INTEGER NOT NULL PRIMARY KEY AUTOINCREMENT,
'nom' VARCHAR(30) NOT NULL UNIQUE, /* couleur pour les voies / Gares / compagnies*/
'categorie' VARCHAR(30) NOT NULL, /*voie/gare/compagnie*/
'prix_hotel' INT DEFAULT NULL,
'serie' INT NOT NULL /*Pas obligatoire car récupérable en utilisant 'count'*/ 
);
INSERT INTO couleur (id, nom, categorie, prix_hotel, serie) VALUES (1, 'marron', 'voie', 150, 2);
INSERT INTO couleur (id, nom, categorie, prix_hotel, serie) VALUES (2, 'bleuciel', 'voie', 250, 3);
INSERT INTO couleur (id, nom, categorie, prix_hotel, serie) VALUES (3, 'rose', 'voie', 350, 3);
INSERT INTO couleur (id, nom, categorie, prix_hotel, serie) VALUES (4, 'orange', 'voie', 450, 3);
INSERT INTO couleur (id, nom, categorie, prix_hotel, serie) VALUES (5, 'rouge', 'voie', 550, 3);
INSERT INTO couleur (id, nom, categorie, prix_hotel, serie) VALUES (6, 'jaune', 'voie', 650, 3);
INSERT INTO couleur (id, nom, categorie, prix_hotel, serie) VALUES (7, 'vert', 'voie', 750, 3);
INSERT INTO couleur (id, nom, categorie, prix_hotel, serie) VALUES (8, 'bleumarine', 'voie', 850, 2);
INSERT INTO couleur (id, nom, categorie, prix_hotel, serie) VALUES (9, 'gare', 'gare', NULL, 4);
INSERT INTO couleur (id, nom, categorie, prix_hotel, serie) VALUES (10, 'compagnie', 'compagnie', NULL, 2);

-- Table : joueur
DROP TABLE IF EXISTS joueur;
CREATE TABLE joueur (
'id' INTEGER NOT NULL PRIMARY KEY AUTOINCREMENT,
'surnom' VARCHAR(20) NOT NULL UNIQUE,
'porte_monnaie' INT NOT NULL DEFAULT 1500 /*En euro*/
);
INSERT INTO joueur (id, surnom, porte_monnaie) VALUES (1, 'chapeau', 550);
INSERT INTO joueur (id, surnom, porte_monnaie) VALUES (2, 'voiture', 330);
INSERT INTO joueur (id, surnom, porte_monnaie) VALUES (3, 'toutou', 1030);

-- Table : joueur_chance
DROP TABLE IF EXISTS joueur_chance;
CREATE TABLE joueur_chance (
    joueur_id INTEGER REFERENCES joueur (id),
    chance_id INTEGER REFERENCES chance (id) 
);
INSERT INTO joueur_chance (joueur_id, chance_id) VALUES (1, 1);
INSERT INTO joueur_chance (joueur_id, chance_id) VALUES (1, 2);
INSERT INTO joueur_chance (joueur_id, chance_id) VALUES (2, 3);
INSERT INTO joueur_chance (joueur_id, chance_id) VALUES (3, 2);
INSERT INTO joueur_chance (joueur_id, chance_id) VALUES (3, 3);

-- Table : propriete
DROP TABLE IF EXISTS propriete;
CREATE TABLE propriete (
'id' INTEGER NOT NULL PRIMARY KEY AUTOINCREMENT,
'nom' VARCHAR(100) NOT NULL,
'prix' INT NOT NULL,
'loyer' INT NOT NULL,
'presence_hotel' BOOLEAN DEFAULT false,
'loyer_hotel' INT,
'joueur_id' INTEGER REFERENCES joueur(id) /*DEFAULT 0*/,
'couleur_id' INTEGER REFERENCES couleur(id)
);
INSERT INTO propriete (id, nom, prix, loyer, presence_hotel, loyer_hotel, joueur_id, couleur_id) VALUES (1, 'boulevard_de_belleville', 60, 30, 1, 120, 2, 1);
INSERT INTO propriete (id, nom, prix, loyer, presence_hotel, loyer_hotel, joueur_id, couleur_id) VALUES (2, 'rue_lecourbe', 60, 30, 1, 120, 2, 1);
INSERT INTO propriete (id, nom, prix, loyer, presence_hotel, loyer_hotel, joueur_id, couleur_id) VALUES (3, 'gare_montparnasse', 200, 50, NULL, NULL, 1, 9);
INSERT INTO propriete (id, nom, prix, loyer, presence_hotel, loyer_hotel, joueur_id, couleur_id) VALUES (4, 'rue_de_vaugirard', 100, 50, 0, 200, NULL, 2);
INSERT INTO propriete (id, nom, prix, loyer, presence_hotel, loyer_hotel, joueur_id, couleur_id) VALUES (5, 'rue_de_courcelles', 100, 50, 0, 200, 1, 2);
INSERT INTO propriete (id, nom, prix, loyer, presence_hotel, loyer_hotel, joueur_id, couleur_id) VALUES (6, 'avenue_de_la_republique', 120, 50, 0, 200, 1, 2);
INSERT INTO propriete (id, nom, prix, loyer, presence_hotel, loyer_hotel, joueur_id, couleur_id) VALUES (7, 'boulevard_de_la_villette', 140, 70, 0, 280, 3, 3);
INSERT INTO propriete (id, nom, prix, loyer, presence_hotel, loyer_hotel, joueur_id, couleur_id) VALUES (8, 'compagnie_de_distribution_d''electricite', 150, 3, NULL, NULL, NULL, 10);
INSERT INTO propriete (id, nom, prix, loyer, presence_hotel, loyer_hotel, joueur_id, couleur_id) VALUES (9, 'avenue_de_neuilly', 140, 70, 0, 280, 3, 3);
INSERT INTO propriete (id, nom, prix, loyer, presence_hotel, loyer_hotel, joueur_id, couleur_id) VALUES (10, 'rue_de_paradis', 160, 80, 0, 320, 3, 3);
INSERT INTO propriete (id, nom, prix, loyer, presence_hotel, loyer_hotel, joueur_id, couleur_id) VALUES (11, 'gare_de_lyon', 200, 50, NULL, NULL, 1, 9);
INSERT INTO propriete (id, nom, prix, loyer, presence_hotel, loyer_hotel, joueur_id, couleur_id) VALUES (12, 'avenue_mozart', 180, 90, 0, 360, NULL, 4);
INSERT INTO propriete (id, nom, prix, loyer, presence_hotel, loyer_hotel, joueur_id, couleur_id) VALUES (13, 'boulevard_saint_michel', 180, 90, 0, 360, 3, 4);
INSERT INTO propriete (id, nom, prix, loyer, presence_hotel, loyer_hotel, joueur_id, couleur_id) VALUES (14, 'place_pigalle', 200, 100, 0, 400, NULL, 4);
INSERT INTO propriete (id, nom, prix, loyer, presence_hotel, loyer_hotel, joueur_id, couleur_id) VALUES (15, 'avenue_matignon', 220, 110, 0, 440, 3, 5);
INSERT INTO propriete (id, nom, prix, loyer, presence_hotel, loyer_hotel, joueur_id, couleur_id) VALUES (16, 'boulevard_malesherbes', 220, 110, 0, 440, NULL, 5);
INSERT INTO propriete (id, nom, prix, loyer, presence_hotel, loyer_hotel, joueur_id, couleur_id) VALUES (17, 'avenue_henri_martin', 240, 120, 0, 480, 3, 5);
INSERT INTO propriete (id, nom, prix, loyer, presence_hotel, loyer_hotel, joueur_id, couleur_id) VALUES (18, 'gare_du_nord', 200, 50, NULL, NULL, 1, 9);
INSERT INTO propriete (id, nom, prix, loyer, presence_hotel, loyer_hotel, joueur_id, couleur_id) VALUES (19, 'faubourg_saint_honore', 260, 130, 0, 520, NULL, 6);
INSERT INTO propriete (id, nom, prix, loyer, presence_hotel, loyer_hotel, joueur_id, couleur_id) VALUES (20, 'place_de_la_bourse', 260, 130, 0, 520, NULL, 6);
INSERT INTO propriete (id, nom, prix, loyer, presence_hotel, loyer_hotel, joueur_id, couleur_id) VALUES (21, 'compagnie_de_distribution_des_eaux', 150, 3, NULL, NULL, 3, 10);
INSERT INTO propriete (id, nom, prix, loyer, presence_hotel, loyer_hotel, joueur_id, couleur_id) VALUES (22, 'rue_la_fayette', 280, 140, 0, 560, NULL, 6);
INSERT INTO propriete (id, nom, prix, loyer, presence_hotel, loyer_hotel, joueur_id, couleur_id) VALUES (23, 'avenue_de_breteuil', 300, 150, 0, 600, 2, 7);
INSERT INTO propriete (id, nom, prix, loyer, presence_hotel, loyer_hotel, joueur_id, couleur_id) VALUES (24, 'avenue_foch', 300, 150, 1, 600, 2, 7);
INSERT INTO propriete (id, nom, prix, loyer, presence_hotel, loyer_hotel, joueur_id, couleur_id) VALUES (25, 'boulevard_des_capucines', 320, 160, 0, 640, 2, 7);
INSERT INTO propriete (id, nom, prix, loyer, presence_hotel, loyer_hotel, joueur_id, couleur_id) VALUES (26, 'gare_saint_lazare', 200, 50, NULL, NULL, 2, 9);
INSERT INTO propriete (id, nom, prix, loyer, presence_hotel, loyer_hotel, joueur_id, couleur_id) VALUES (27, 'avenue_des_champs_elysees', 350, 180, 0, 700, 1, 8);
INSERT INTO propriete (id, nom, prix, loyer, presence_hotel, loyer_hotel, joueur_id, couleur_id) VALUES (28, 'rue_de_la_paix', 400, 200, 1, 800, 1, 8);

-- Vue : carte_propriete_vw
DROP VIEW IF EXISTS carte_propriete_vw;
CREATE VIEW carte_propriete_vw AS SELECT propriete.id, couleur.nom AS 'couleur', propriete.nom AS 'nom', loyer, loyer*2 AS 'loyer_double', loyer_hotel, couleur.prix_hotel AS 'prix_hotel', prix AS 'prix_propriete' FROM propriete JOIN couleur ON propriete.couleur_id=couleur.id;

COMMIT TRANSACTION;
PRAGMA foreign_keys = on;
